using System;
using System.Diagnostics;

namespace Implab {
    class PromiseFuncReaction<TRet> : PromiseReaction {
        readonly Action m_fulfilled;

        readonly Action<Exception> m_rejected;

        readonly Deferred<TRet> m_next;

        public PromiseFuncReaction(Func<TRet> fulfilled, Func<Exception, TRet> rejected, Deferred<TRet> next, IDispatcher dispatcher) : base(dispatcher) {
            if (fulfilled != null)
                m_fulfilled = () => { next.Resolve(fulfilled()); };

            if (rejected != null)
                m_rejected = (e) => { next.Resolve(rejected(e)); };
            m_next = next;
        }

        public PromiseFuncReaction(Func<IPromise<TRet>> fulfilled, Func<Exception, IPromise<TRet>> rejected, Deferred<TRet> next, IDispatcher dispatcher) : base(dispatcher) {
            if (fulfilled != null)
                m_fulfilled = () => { next.Resolve(fulfilled()); };
            if (rejected != null)
                m_rejected = (e) => { next.Resolve(rejected(e)); };
            m_next = next;
        }

        public PromiseFuncReaction(Func<TRet> fulfilled, Func<Exception, IPromise<TRet>> rejected, Deferred<TRet> next, IDispatcher dispatcher) : base(dispatcher) {
            if (fulfilled != null)
                m_fulfilled = () => { next.Resolve(fulfilled()); };
            if (rejected != null)
                m_rejected = (e) => { next.Resolve(rejected(e)); };

            m_next = next;
        }

        public PromiseFuncReaction(Func<IPromise<TRet>> fulfilled, Func<Exception, TRet> rejected, Deferred<TRet> next, IDispatcher dispatcher) : base(dispatcher) {
            if (fulfilled != null)
                m_fulfilled = () => { next.Resolve(fulfilled()); };
            if (rejected != null)
                m_rejected = (e) => { next.Resolve(rejected(e)); };

            m_next = next;
        }


        protected override bool HasFulfilHandler => m_fulfilled != null;

        protected override bool HasRejectHandler => m_rejected != null;

        protected override void DefaultReject(Exception reason) {
            m_next.Reject(reason);
        }

        protected override void DefaultResolve() {
            throw new NotImplementedException();
        }

        protected override void RejectImpl(Exception reason) {
            try {
                m_rejected(reason);
            } catch (Exception e){
                m_next.Reject(e);
            }
        }

        protected override void ResolveImpl() {
            try {
                m_fulfilled();
            } catch (Exception e){
                m_next.Reject(e);
            }
        }
    }
}